/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.math.BigDecimal;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.NumberQuantity;

final class LongQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private static final BigDecimal LONG_MAX_VALUE_AS_BIG_DECIMAL = new BigDecimal(Long.MAX_VALUE);
    private static final long serialVersionUID = 3092808554937634365L;
    final long value;

    public LongQuantity(long value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? (double)this.value : super.getUnit().getConverterTo(unit).convert(this.value);
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    private boolean isOverflowing(BigDecimal value) {
        return value.compareTo(LONG_MAX_VALUE_AS_BIG_DECIMAL) > 0;
    }

    private ComparableQuantity<Q> addRaw(Number a, Number b, Unit<Q> unit) {
        return NumberQuantity.of(a.longValue() + b.longValue(), unit);
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        Quantity<Q> thatConverted = that.to(this.getUnit());
        Quantity thisConverted = this.to((Unit)that.getUnit());
        BigDecimal resultValueInThisUnit = new BigDecimal(this.getValue()).add(new BigDecimal(thatConverted.getValue().doubleValue()));
        BigDecimal resultValueInThatUnit = new BigDecimal(thisConverted.getValue().doubleValue()).add(new BigDecimal(that.getValue().doubleValue()));
        ComparableQuantity resultInThisUnit = this.addRaw(this.getValue(), thatConverted.getValue(), this.getUnit());
        ComparableQuantity<Q> resultInThatUnit = this.addRaw(thisConverted.getValue(), that.getValue(), that.getUnit());
        if (this.isOverflowing(resultValueInThisUnit)) {
            if (this.isOverflowing(resultValueInThatUnit)) {
                throw new ArithmeticException();
            }
            return resultInThatUnit;
        }
        if (this.isOverflowing(resultValueInThatUnit)) {
            return resultInThisUnit;
        }
        if (this.hasFraction(resultValueInThisUnit)) {
            return resultInThatUnit;
        }
        return resultInThisUnit;
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        AbstractQuantity<Q> thatNegated = NumberQuantity.of(-that.getValue().longValue(), that.getUnit());
        return this.add((Quantity)thatNegated);
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return new LongQuantity(this.value * that.getValue().longValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return NumberQuantity.of(this.value * that.longValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return NumberQuantity.of((double)this.value / that.getValue().doubleValue(), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public AbstractQuantity<Q> inverse() {
        return NumberQuantity.of(1L / this.value, this.getUnit().inverse());
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return NumberQuantity.of((double)this.value / that.doubleValue(), this.getUnit());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit) {
        return BigDecimal.valueOf(this.doubleValue(unit));
    }
}

